import { traceContext } from "../common/trace.mjs";
import { logger } from "../logger/index.mjs";
import { params_exports } from "../params/index.mjs";
import { setApp } from "../common/app.mjs";
import { Change } from "../common/change.mjs";
import { onInit } from "../common/onInit.mjs";
import { config } from "../v1/config.mjs";
import "./core.mjs";
import { setGlobalOptions } from "./options.mjs";
import { alerts_exports } from "./providers/alerts/index.mjs";
import { database_exports } from "./providers/database.mjs";
import { eventarc_exports } from "./providers/eventarc.mjs";
import { https_exports } from "./providers/https.mjs";
import { identity_exports } from "./providers/identity.mjs";
import { pubsub_exports } from "./providers/pubsub.mjs";
import { scheduler_exports } from "./providers/scheduler.mjs";
import { storage_exports } from "./providers/storage.mjs";
import { tasks_exports } from "./providers/tasks.mjs";
import { remoteConfig_exports } from "./providers/remoteConfig.mjs";
import { testLab_exports } from "./providers/testLab.mjs";
import { firestore_exports } from "./providers/firestore.mjs";
import { dataconnect_exports } from "./providers/dataconnect.mjs";

//#region src/v2/index.ts
const app = { setEmulatedAdminApp: setApp };

//#endregion
export { Change, alerts_exports as alerts, app, config, database_exports as database, dataconnect_exports as dataconnect, eventarc_exports as eventarc, firestore_exports as firestore, https_exports as https, identity_exports as identity, logger, onInit, params_exports as params, pubsub_exports as pubsub, remoteConfig_exports as remoteConfig, scheduler_exports as scheduler, setGlobalOptions, storage_exports as storage, tasks_exports as tasks, testLab_exports as testLab, traceContext };